function ButtonTrackingObj(exp, titleName, cm, frame){
   this.VarTrivBtnTracking = new Variable( 'VarTrivBtnTracking', null, 0, cm, frame, exp, titleName, true );
   this.title = null;
}

ButtonTrackingObj.codeToStateMap =
{
	'N' : 'normalState',
	'O' : 'overState',
	'D' : 'downState',
	'A' : 'disabledState',
	'V' : 'visitedState',
	'S' : 'selectedState'
};
ButtonTrackingObj.stateToCodeMap = {};
for (var key in ButtonTrackingObj.codeToStateMap)
	ButtonTrackingObj.stateToCodeMap[ButtonTrackingObj.codeToStateMap[key]] = key;

ButtonTrackingObj.prototype.InitPageTracking = function ( )
{
	var THIS = this;
	var pageTrackData = this.VarTrivBtnTracking.getValue();
	var bDoInit = true;
	try {
	    if (pageTrackData && pageTrackData.length > 0 && pageTrackData != '~~~null~~~')
	    {
	        var topLevelSplit = pageTrackData.split('#');
	        if (topLevelSplit && topLevelSplit.length > 1)
            {
		        var arrIds = topLevelSplit[0].split(',');
		        var arrStatus = topLevelSplit[1].split(',');
		        for( var i=0; i<arrIds.length; i++ )
		        {
			        var id = parseInt( '0x' + arrIds[i] );
			        var status = arrStatus[i];
			        var node = this.FindNode( this.title, id );
			        if( node )
						node.v = ButtonTrackingObj.codeToStateMap[status] || status;
		        }
    		}
        }
    } catch (e) { }
}

ButtonTrackingObj.prototype.FindNode = function( node, id )
{
	if( node.id == id )
		return node;
	
	var match = null;
	if( typeof( node.c ) != 'undefined' ){
		for( var i=0; i<node.c.length; i++ ){
			match = this.FindNode( node.c[i], id );
			if( match != null )
				break;
		}
	}
	
	return match;
}

ButtonTrackingObj.prototype.InternalGetRangeStatus = function( node )
{
	if( node == null )
		return -1;
		
	if( typeof(node.c) == 'undefined' )
	{
		return node.v;
	}
	else
	{
		return 'normalState';
	}
}


ButtonTrackingObj.prototype.GetRangeStatus = function( id, bInit )
{
	var status = -1;
	if ( bInit ) 
		this.InitPageTracking();
	
	status = this.InternalGetRangeStatus( this.FindNode( this.title, id ) );

	return status;
}


ButtonTrackingObj.prototype.InternalSetRangeStatus=function( node, status )
{
	if( node == null )
		return;
	node.v = status;
	if( status == 0 && typeof(node.c)!='undefined')
	{
		for( var i=0; i<node.c.length; i++ )
			this.InternalSetRangeStatus( node.c[i], status ); 
	}
}

ButtonTrackingObj.prototype.SetRangeStatus = function( id, status /*0 or 1 or 2*/)
{
	this.InternalSetRangeStatus( this.FindNode(this.title, id), status );
	
	this.SavePageTracking();
}

ButtonTrackingObj.prototype.IterateTree = function( func )
{
	var stack = [];
	stack.push( this.title );
	var i = 0;
	while( stack.length > 0 )
	{
		var node = stack.shift();
		
		if( typeof(node.c) != 'undefined' )
			stack = node.c.concat(stack);
			
		//do the thing
		func( node, i, stack );
		i++;
	}	
}

ButtonTrackingObj.prototype.SavePageTracking = function()
{
	var fnIsSaveState = window.ObjButton && ObjButton.isSaveState || function () { return false; };
	var hexString = '';
	var arrayIds = [];
	var arrayStatus= [];
	
	this.IterateTree(function(node, i, stack){
		if (fnIsSaveState(node.v))
		{
			arrayIds.push(node.id);
			arrayStatus.push(node.v);
		}
	});
	
	for( var i=0; i<arrayIds.length; i++ )
		hexString += (i > 0 ? ',' : '') + arrayIds[i].toString(16);

	hexString += (arrayIds.length > 0 ? '#' : '');
	
	for (var i = 0; i < arrayStatus.length; i++)
		hexString += (i > 0 ? ',' : '') + (ButtonTrackingObj.stateToCodeMap[arrayStatus[i]] || arrayStatus[i]);

	//LD-8267 - Added a condition to avoid tracking null/empty data unnecessarily
	if (hexString.length > 0 || (getDisplayWindow().storeSuspendData && getDisplayWindow().storeSuspendData.indexOf('VarTrivBtnTracking') >= 0) || !this.VarTrivBtnTracking.bSCORM)
		this.VarTrivBtnTracking.set(hexString);
}

var trivBtnTracking = new ButtonTrackingObj(365,'southlake_sure_learning_module', 0, null);
trivBtnTracking.title={id:1,v:0,c:[{id:1762,v:'normalState'},{id:1758,v:'normalState'},{id:8022,v:'normalState'},{id:80425,v:'normalState'},{id:80647,v:'normalState'},{id:81576,v:'normalState'},{id:82442,v:'normalState'},{id:124509,v:'normalState'},{id:123700,v:'normalState'},{id:83097,v:'normalState'},{id:121834,v:'normalState'},{id:142692,v:'normalState'},{id:124095,v:'normalState'},{id:134369,v:'normalState'},{id:128490,v:'normalState'},{id:126134,v:'normalState'},{id:125318,v:'normalState'},{id:83419,v:'normalState'},{id:84271,v:'normalState'},{id:84646,v:'normalState'},{id:84974,v:'normalState'},{id:144192,v:'normalState'},{id:144544,v:'normalState'},{id:145186,v:'normalState'},{id:145702,v:'normalState'},{id:146186,v:'normalState'},{id:146604,v:'normalState'},{id:144385,v:'normalState'},{id:146949,v:'normalState'},{id:129542,v:'normalState'},{id:129522,v:'normalState'},{id:130552,v:'normalState'},{id:130702,v:'normalState'},{id:148618,v:'normalState'},{id:171856,v:'normalState'},{id:131034,v:'normalState'},{id:131170,v:'normalState'},{id:131473,v:'normalState'},{id:131413,v:'normalState'},{id:131375,v:'normalState'},{id:131355,v:'normalState'},{id:93958,v:'normalState'},{id:94164,v:'normalState'},{id:95317,v:'normalState'},{id:151996,v:'normalState'},{id:161506,v:'normalState'},{id:162224,v:'normalState'},{id:162634,v:'normalState'},{id:162741,v:'normalState'},{id:162867,v:'normalState'},{id:132070,v:'normalState'},{id:132124,v:'normalState'},{id:132247,v:'normalState'},{id:132313,v:'normalState'},{id:132498,v:'normalState'},{id:132674,v:'normalState'},{id:132783,v:'normalState'},{id:132860,v:'normalState'},{id:101430,v:'normalState'},{id:101768,v:'normalState'},{id:104730,v:'normalState'},{id:155478,v:'normalState'},{id:156481,v:'normalState'},{id:133453,v:'normalState'},{id:106353,v:'normalState'},{id:106551,v:'normalState'},{id:157651,v:'normalState'},{id:174372,v:'normalState'},{id:165422,v:'normalState'},{id:180886,v:'normalState'},{id:138721,v:'normalState'},{id:139638,v:'normalState'},{id:139646,v:'normalState'}]};
